function RNLTV_denoising_Fig15_barbara
%
%setup the path
curDir=pwd; %Identify current folder

addessFolder = strjoin({curDir,'img_png_NLTV'},filesep);
path(addessFolder,path);

application.name = 'denoising';

ExpFolderName = 'results';

% PreProcessing folder
appDataFolder = ['PreProcess',upper(application.name(1)),...
    application.name(2:end),'Data'];
preprocessDataFolderPath = strjoin({curDir,appDataFolder},filesep);


ExpFolderPath = strjoin({curDir,ExpFolderName,application.name},filesep);
if ~exist(ExpFolderPath , 'dir')
    mkdir(ExpFolderPath );
end

fileName_array = {'barbara120' };

nbIter = 600;
radius = 5;
init = 3;

application.data_term = 1;

lambda = 0.5;
mu=0.6;
hsigma=0.05;

sigm_array= [0.04 0.06 0.08];

for i_fileName = 1:length(fileName_array)
    fileName = fileName_array{i_fileName};
    
    ExpSubfolderPath = strjoin({ExpFolderPath,fileName},filesep);
    if ~exist( ExpSubfolderPath, 'dir')
        mkdir( ExpSubfolderPath);
    end
    
    polSubFolderPath =strjoin({ExpSubfolderPath,'pol'},filesep);
    if ~exist( polSubFolderPath, 'dir')
        mkdir( polSubFolderPath);
    end
    
    % load in_clean
    [in_clean,map] = imread([fileName,'.png']);
    in_clean = double(in_clean); in_clean = in_clean/ max(in_clean(:));
    
    for i_sigm = 1:length(sigm_array)
        
        sigm = sigm_array(i_sigm);
        
        %add noise
        tempImgName = [fileName,...
            '_sg', num2str(sigm)];
        rng(8,'twister');
        in_polluted = in_clean + sigm*randn(size(in_clean));
        if ~exist(polSubFolderPath, 'dir')
            mkdir(polSubFolderPath);
        end
        save(strjoin({polSubFolderPath,...
            [tempImgName,'_in_polluted','.mat']},filesep), 'in_polluted');
        
        switch sigm
            case 0.04
                gama = 0.05;
            case 0.06
                gama = 0.1;
            case 0.08
                gama = 0.2;
            otherwise
                fprintf('norecord\n');
                return
        end
        
        partialMatName = strjoin({preprocessDataFolderPath,fileName,'tv',...
            [tempImgName,'_pTV.mat']},filesep);
        load(partialMatName)
        application.init_u = u;
        
        [u,v,energies] = regularized_NLTV(in_polluted,nbIter,radius,mu,...
            lambda,gama, hsigma, init, application);
        psnr = psnr1(u,in_clean)
        
        imgResultNameFolderPath = strjoin({ExpSubfolderPath,...
            tempImgName},filesep);
        
        % save image results
        save([imgResultNameFolderPath '_u_.mat'],'u');
        
    end
end